#include "i2c_oled.h"

#define DELAY_TIME	2


//
void Config_I2C(void)
{
//	LL_I2C_InitTypeDef I2C_InitStruct;
	
	LL_GPIO_InitTypeDef GPIO;

	LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_I2C3);
	LL_RCC_SetI2CClockSource(LL_RCC_I2C3_CLKSOURCE_HSI);
	
	LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOB);
	LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOA);
	
	/* Configure SCL Pin as : Alternate function, High Speed, Open drain, Pull up */

	GPIO.Pin = LL_GPIO_PIN_8;	
	GPIO.Mode = LL_GPIO_MODE_ALTERNATE;
	GPIO.Alternate = LL_GPIO_AF_7;
	GPIO.OutputType = LL_GPIO_OUTPUT_OPENDRAIN;
	GPIO.Pull = LL_GPIO_PULL_UP;
	GPIO.Speed = LL_GPIO_SPEED_FREQ_VERY_HIGH;
	LL_GPIO_Init(GPIOA, &GPIO);
	
	GPIO.Pin = LL_GPIO_PIN_4;
	LL_GPIO_Init(GPIOB, &GPIO);

	LL_I2C_Disable(I2C3);

	I2C3->TIMINGR = (uint32_t )0x00B25C80;

	I2C3->CR1 = I2C_CR1_PE;
	I2C3->CR2 = I2C_CR2_AUTOEND | (0x78) | (2 << 16);	

}

//
void I2C_Master_Send2Bytes(uint8_t data1, uint8_t data2)
{
	uint32_t timeout = 0x1ff;
	
	while((I2C3->ISR & I2C_ISR_BUSY) && (timeout != 0)){
		timeout--;
	}
	
	if(timeout != 0){
		
		LL_I2C_GenerateStartCondition(I2C3);
		
		LL_I2C_TransmitData8(I2C3,data1);
		while(LL_I2C_IsActiveFlag_TXE(I2C3) == 0);
		
		LL_I2C_TransmitData8(I2C3,data2);
		while(LL_I2C_IsActiveFlag_TXE(I2C3) == 0);
	}else{
		;	//return false
	}
}
