#include <STC15F2K60S2.H>
#include <74hc138.H>
#include <Nixie.H>
#include <Key.H>
#include <onewire.H>
//#include <ultrasound.H>
#include <intrins.h>

static unsigned char Key_Val, Key_Old, Key_Down, Key_Up;
static unsigned char show_mode=0;
bit shift_mode=0;
bit flag,flag_t,flag_led;
static char fix=0,set=26;
float t;

void Delay(unsigned int xms)	//@12.000MHz
{
	unsigned char data i, j;
	while(xms--)
	{
		i = 12;
		j = 169;
		do
		{
			while (--j);
		} while (--i);
	}
}



void Timer0_Init(void)		//1毫秒@12.000MHz
{
	AUXR &= 0x7F;			//定时器时钟12T模式
	TMOD &= 0xF0;			//设置定时器模式
	TL0 = 0x18;				//设置定时初始值
	TH0 = 0xFC;				//设置定时初始值
	TF0 = 0;				//清除TF0标志
	TR0 = 1;				//定时器0开始计时
	ET0 = 1;				//使能定时器0中断
	EA = 1;
}


void sys_init()
{
	P0=0xff;
	InitHC138(4);
	P0=0x00;
	InitHC138(5);
}

void LED(unsigned char addr,enable)
{
	static unsigned char temp=0x00,temp_old=0xff;
	if(enable)
		temp|=0x01<<addr;
	else 
		temp&=~(0x01<<addr);
	if(temp!=temp_old)
	{
		P0=~temp;
		InitHC138(4);
		temp_old=temp;
	}
}

void Key_Loop()
{
	Key_Val=ScanKey();
	Key_Down=Key_Val&(Key_Old^Key_Val);
	Key_Up=~Key_Val&(Key_Old^Key_Val);
	Key_Old=Key_Val;
	if(Key_Down==5)
	{
		shift_mode=~shift_mode;
	}

	if(Key_Down==4)
	{
		show_mode++;
		if(show_mode>=3)show_mode=0;
	}
	if(show_mode==1)
	{
		if(Key_Down==8)
		{
			if(fix>(-99)&&fix<=99)
				fix--;
		}
		if(Key_Down==9)
		{
			if(fix>=(-99)&&fix<99)
				fix++;
		}
	}
	else if(show_mode==2)
	{
		if(Key_Down==8)
		{
			if(set>(-99)&&set<=99)
				set--;
		}
		if(Key_Down==9)
		{
			if(set>=(-99)&&set<99)
				set++;
		}
	}
}

void t_show()
{
	if(flag_t)
	{
		flag_t=0;
		t=read_t()+fix;
	}
	Nixie_SetBuf(1,12);
	Nixie_SetBuf(2,19);
	Nixie_SetBuf(3,19);
	Nixie_SetBuf(4,19);
	Nixie_SetBuf(5,19);
	Nixie_SetBuf(6,((unsigned int)t/10)==0?19:(unsigned int)t/10	);
	Nixie_SetBuf(7,(unsigned int)t%10);
	Nixie_SetBuf(8,(unsigned int)(t*10)%10);
	point[7]=1;
}

void fix_show()
{
	Nixie_SetBuf(1,14);
	Nixie_SetBuf(2,19);
	Nixie_SetBuf(3,19);
	Nixie_SetBuf(4,19);
	Nixie_SetBuf(5,19);
	if(fix>=0)
	{
		Nixie_SetBuf(6,19);
		Nixie_SetBuf(7,(fix/10)!=0?fix/10:19);
		Nixie_SetBuf(8,fix%10);
		
	}
	if(fix<0)
	{
		Nixie_SetBuf(6,(-fix/10)!=0?20:19);
		Nixie_SetBuf(7,(-fix/10)!=0?(-fix)/10:20);
		Nixie_SetBuf(8,(-fix)%10);
	}
	point[7]=0;
}

void set_show()
{
	Nixie_SetBuf(1,21);
	Nixie_SetBuf(2,19);
	Nixie_SetBuf(3,19);
	Nixie_SetBuf(4,19);
	Nixie_SetBuf(5,19);
	if(set>=0)
	{
		Nixie_SetBuf(6,19);
		Nixie_SetBuf(7,(set/10)!=0?set/10:19);
		Nixie_SetBuf(8,set%10);
		
	}
	if(set<0)
	{
		Nixie_SetBuf(6,(-set/10)!=0?20:19);
		Nixie_SetBuf(7,(-set/10)!=0?(-set)/10:20);
		Nixie_SetBuf(8,(-set)%10);
	}
	point[7]=0;
}

void led_show()
{
	if(shift_mode==0)
	{
		LED(3,1);
		LED(4,0);
		if(t>set)
		{
			LED(7,1);
		}
		else 
			LED(7,0);
	}
	else
	{
		LED(3,0);
		LED(4,1);
		if(t<set)
		{
			LED(7,1);
		}
		else 
			LED(7,0);
	}
	if(show_mode==0)
	{
		LED(0,1);
		LED(1,0);
		LED(2,0);
	}
	else if(show_mode==1)
	{
		LED(0,0);
		LED(1,1);
		LED(2,0);
	}
	else if(show_mode==2)
	{
		LED(0,0);
		LED(1,0);
		LED(2,1);
	}
}

void main()
{
	Timer0_Init();
	sys_init();
	read_t();
	Delay(750);
	while(1)
	{
		led_show();
		if(show_mode==0)
		{
			t_show();
		}
		else if(show_mode==1)
		{
			fix_show();
		}
		else if(show_mode==2)
		{
			set_show();
		}
	}
}
void Timer0_Isr(void) interrupt 1
{
	static unsigned char count0,count1,count3;
	static unsigned int count2;
	count0++;
	count1++;
	count2++;
	count3++;
	if(count0>=2)
	{
		count0=0;
		Nixie_Loop();
	}
	if(count1>=10)
	{
		count1=0;
		Key_Loop();
	}
	if(count2>=500)
	{
		count2=0;
		flag_t=1;
	}

}