#include <STC15F2K60S2.H>
#include <74hc138.H>
#include <Nixie.H>
#include <Key.H>
#include <iic.H>
#include <ds1302.H>

static unsigned char Key_Val, Key_Old, Key_Down, Key_Up;
static unsigned char Rct[3]={0x23,0x09,0x59},max_t[3]={0x00,0x00,0x00};
int fcount, dat, max_f;
float k,b,v_out;

static bit s_mode=0,back_mode=0,flag_l1;

static  int lim,fix,show_mode=0;
static unsigned char lim_index=2;
static char fix_index=0;


void Delay5ms(void)	//@12.000MHz
{
	unsigned char data i, j;

	i = 59;
	j = 90;
	do
	{
		while (--j);
	} while (--i);
}


void InitTimer()
{
	TH0=0xff;
	TL0=0xff;// 计数器模式
	
	TH1=(65535-1000)/256;
	TL1=(65535-1000)%256;// 1ms定时器
	
	TMOD=0x16;// 设定模式：定时器0为计数 定时器1为定时
	ET0=1;
	ET1=1; // 打开定时器开关
	EA=1; // 打开总开关
	
	TR0=1;
	TR1=1; // 开始工作
}

void LED(unsigned char addr, enable)
{
	static unsigned char temp=0x00,temp_old=0xff;
	if(enable)
		temp|=(0x01<<addr);
	else
		temp&=~(0x01<<addr);
	if(temp != temp_old)
	{
		P0 = ~temp;
		InitHC138(4);
		temp_old = temp;
	}
}

void Key_Loop()
{
	Key_Val=ScanKey();
	Key_Down=Key_Val&(Key_Old^Key_Val);
	Key_Up=~Key_Val&(Key_Old^Key_Val);
	Key_Old=Key_Val;
	if(Key_Down==4)
	{
		show_mode++;
		if(show_mode>=4)show_mode=0;
		if(show_mode==1)s_mode=0;
		if(show_mode==3)back_mode=0;
	}
	if(show_mode==1)
	{
		if(Key_Down==5)
			s_mode=~s_mode;
		if(s_mode==0)
		{
			if(Key_Down==8&&lim_index<9)
				lim_index++;
			else if(Key_Down==9&&lim_index>1)
				lim_index--;
		}
		else if(s_mode==1)
		{
			if(Key_Down==8&&fix_index<9)
				fix_index++;
			else if(Key_Down==9&&fix_index>-9)
				fix_index--;
		}

	}
	if(show_mode==3)
	{
		if(Key_Down==5)
			back_mode=~back_mode;
//		if(back_mode==0)
//		{
//			
//		}
//		else if(back_mode==1)
//		{
//			flag_b_f=1;
//		}
	}
}

void sys_init()
{
	P0=0xff;
	InitHC138(4);
	P0=0x00;
	InitHC138(5);
}

void f_show()
{
	
	Nixie_SetBuf(1,15);
	Nixie_SetBuf(2,19);
	Nixie_SetBuf(3,19);
	if((dat+fix)>9999)
	{
		Nixie_SetBuf(4,(dat+fix)/10000);	
		Nixie_SetBuf(5,((dat+fix)/1000)%10);	
		Nixie_SetBuf(6,((dat+fix)/100)%10);	
		Nixie_SetBuf(7,((dat+fix)/10)%10);
		Nixie_SetBuf(8,(dat+fix)%10);
	}
	else if((dat+fix)<=9999&&(dat+fix)>999)
	{
		Nixie_SetBuf(4,19);
		Nixie_SetBuf(5,((dat+fix)/1000)%10);	
		Nixie_SetBuf(6,((dat+fix)/100)%10);	
		Nixie_SetBuf(7,((dat+fix)/10)%10);
		Nixie_SetBuf(8,(dat+fix)%10);
	}
	else if((dat+fix)<=999&&(dat+fix)>99)
	{
		Nixie_SetBuf(4,19);
		Nixie_SetBuf(5,19);
		Nixie_SetBuf(6,((dat+fix)/100)%10);	
		Nixie_SetBuf(7,((dat+fix)/10)%10);
		Nixie_SetBuf(8,(dat+fix)%10);
	}
	else if((dat+fix)<=99&&(dat+fix)>9)
	{
		Nixie_SetBuf(4,19);
		Nixie_SetBuf(5,19);
		Nixie_SetBuf(6,19);	
		Nixie_SetBuf(7,((dat+fix)/10)%10);
		Nixie_SetBuf(8,(dat+fix)%10);
	}
	else if((dat+fix)<=9&&(dat+fix)>=0)
	{
		Nixie_SetBuf(4,19);
		Nixie_SetBuf(5,19);
		Nixie_SetBuf(6,19);	
		Nixie_SetBuf(7,19);
		Nixie_SetBuf(8,(dat+fix)%10);
	}
	else
	{
		Nixie_SetBuf(4,19);
		Nixie_SetBuf(5,19);
		Nixie_SetBuf(6,19);	
		Nixie_SetBuf(7,23);
		Nixie_SetBuf(8,23);
	}
//		Nixie_SetBuf(4,(dat+fix)/10000);	
//	if((dat+fix)<1000)
//		Nixie_SetBuf(5,19);
//	else
//		Nixie_SetBuf(5,((dat+fix)/1000)%10);	
//	if((dat+fix)<100)
//		Nixie_SetBuf(6,19);
//	else
//		Nixie_SetBuf(6,((dat+fix)/100)%10);	
//	if((dat+fix)<10)
//		Nixie_SetBuf(7,19);
//	else
//		Nixie_SetBuf(8,dat+fix);	
//	if((dat+fix)<0)
//	{
//		Nixie_SetBuf(7,23);	
//		Nixie_SetBuf(8,23);	
//	}
//	else
//	{
//		Nixie_SetBuf(7,((dat+fix)/10)%10);
//		Nixie_SetBuf(8,(dat+fix)%10);
//	}
	



}

void set_show()
{
	Nixie_SetBuf(1,22);
	if(s_mode==0)
	{
		Nixie_SetBuf(2,1);
		Nixie_SetBuf(3,19);
		Nixie_SetBuf(4,19);
		Nixie_SetBuf(5,lim_index);
		Nixie_SetBuf(6,0);
		Nixie_SetBuf(7,0);
		Nixie_SetBuf(8,0);
	}
	else 
	{
		Nixie_SetBuf(2,2);
		if(fix_index==0)
		{
			Nixie_SetBuf(5,19);
			Nixie_SetBuf(6,19);
			Nixie_SetBuf(7,19);
			Nixie_SetBuf(8,0);
		}
		else if(fix_index<0)
		{
			Nixie_SetBuf(5,20);
			Nixie_SetBuf(6,-fix_index);
			Nixie_SetBuf(7,0);
			Nixie_SetBuf(8,0);
		}
		else if(fix_index>0)
		{
			Nixie_SetBuf(5,19);
			Nixie_SetBuf(6,fix_index);
			Nixie_SetBuf(7,0);
			Nixie_SetBuf(8,0);
		}
	}

	
}

void t_show()
{
	ReadRct(Rct);
	Nixie_SetBuf(1,Rct[0]/16);
	Nixie_SetBuf(2,Rct[0]%16);
	Nixie_SetBuf(3,20);
	Nixie_SetBuf(4,Rct[1]/16);
	Nixie_SetBuf(5,Rct[1]%16);
	Nixie_SetBuf(6,20);
	Nixie_SetBuf(7,Rct[2]/16);
	Nixie_SetBuf(8,Rct[2]%16);
}

void back_show()
{
	Nixie_SetBuf(1,21);
	if(back_mode==0)
	{
		Nixie_SetBuf(2,15);
		Nixie_SetBuf(3,19);
		if(max_f<=9999)
			Nixie_SetBuf(4,19);
		else
			Nixie_SetBuf(4,max_f/10000);	
		if(max_f<1000)
			Nixie_SetBuf(5,19);
		else
			Nixie_SetBuf(5,(max_f/1000)%10);	
		if(max_f<100)
			Nixie_SetBuf(6,19);
		else
			Nixie_SetBuf(6,(max_f/100)%10);	
		Nixie_SetBuf(7,(max_f/10)%10);
		Nixie_SetBuf(8,max_f%10);
	}
	else
	{
		Nixie_SetBuf(2,10);
		Nixie_SetBuf(3,max_t[0]/16);
		Nixie_SetBuf(4,max_t[0]%16);
		Nixie_SetBuf(5,max_t[1]/16);
		Nixie_SetBuf(6,max_t[1]%16);
		Nixie_SetBuf(7,max_t[2]/16);
		Nixie_SetBuf(8,max_t[2]%16);
		
	}
}

void DA_out()
{
//	dat+fix
//	y=kx+b
	fix=fix_index*100;
	k=4.0/((lim_index*1000.0)-500.0);
	b=1.0-(k*500.0);
	if((dat+fix)>=500||(dat+fix)<=(lim_index*1000))
	{
		v_out=((k*(dat+fix))+b);
	}
	if((dat+fix)<500&&(dat+fix)>=0)
	{
		v_out=1;
	}
	if((dat+fix)>(lim_index*1000))
	{
		v_out=5;
	}
	if((dat+fix)<0)
		v_out=0;
	DA_Write(v_out*51.0);
}

void led_show()
{
	if(show_mode==0)
	{
		if(flag_l1)
			LED(0,1);
		else
			LED(0,0);
	}
	else
		LED(0,0);
//	if((dat+fix)>(lim_index*1000))
//	{
//		if(flag_l1)
//			LED(1,1);
//		else
//			LED(1,0);
//	}
//	else
//		LED(1,0);
	if((dat+fix)<0)
		LED(1,1);
	else if((dat+fix)>(lim_index*1000))
	{
		if(flag_l1)
			LED(1,1);
		else
			LED(1,0);
	}
	else
		LED(1,0);
}

void main()
{
	InitTimer();
	sys_init();
	SetRct(Rct);
	while(1)
	{
		led_show();
		DA_out();
		if((dat+fix)>max_f)
		{
			max_f=(dat+fix);
			ReadRct(max_t);
		}
		if(show_mode==0)
		f_show();
		else if(show_mode==1)
		set_show();
		else if(show_mode==2)
		t_show();
		else if(show_mode==3)
		back_show();
	}
}

void SeverTime0() interrupt 1
{
	fcount++;
}

void SeverTime1() interrupt 3
{
	static unsigned int count0;
	static unsigned char count1, count2, count3;
	TH1=(65535-1000)/256;
	TL1=(65535-1000)%256; // 不自动重装载，设定初值
	
	count0++;
	if(count0>=1000)
	{
		dat=fcount;
		fcount=0;
		count0=0;
	}
	count1++;
	if(count1>=2)
	{
		Nixie_Loop();
		count1=0;
	}
	count2++;
	if(count2>=10)
	{
		Key_Loop();
		count2=0;
	}
	count3++;
	if(count3>=200)
	{
		flag_l1=~flag_l1;
		count3=0;
	}
}
