#include <STC15F2K60S2.H>
#include <intrins.h>

sbit Tx=P1^0;
sbit Rx=P1^1;

void Delay14us(void)	//@12.000MHz
{
	unsigned char data i;

	_nop_();
	_nop_();
	i = 39;
	while (--i);
}

void WaveInit()
{
	unsigned char i=0;
	EA=CR=0;
	for(i=0;i<8;i++)
	{
		Tx=1;
		Delay14us();
		Tx=0;
		Delay14us();
	}
	EA=CR=1;
}

unsigned int csb()
{
	unsigned int time;
	
	CMOD=0x00;
	CH=CL=0;
	WaveInit();
	CR=1;
	
	while(Rx==1&CF==0);
	
	CR=0;
	if(CF==0)
	{
		time=(CH<<8)|CL;
		return (time*0.017+3);
	}
	else
	{
		CF=0;
		return 999;
	}
}