#include <STC15F2K60S2.H>
#include <74hc138.H>
#include <Nixie.H>
#include <Key.H>
#include <iic.H>
#include <ultrasound.H>
#include <intrins.h>

static unsigned char Key_Val, Key_Old, Key_Down, Key_Up;
static unsigned char show_mode=0;
bit shift_mode=0;
bit flag,flag_v,flag_led;
static bit flag_old=0,flag_a=0;
static unsigned char c_alarm=0;
unsigned char upBuf[5]={50,60,70,80,90};
unsigned char downBuf[5]={0,10,20,30,40};
unsigned char lim_up=60,lim_down=10;
unsigned int distance;
float v;

void Delay500ms(void)	//@12.000MHz
{
	unsigned char data i, j, k;

	_nop_();
	_nop_();
	i = 23;
	j = 205;
	k = 120;
	do
	{
		do
		{
			while (--k);
		} while (--j);
	} while (--i);
}


void Timer0_Init(void)		//1毫秒@12.000MHz
{
	AUXR &= 0x7F;			//定时器时钟12T模式
	TMOD &= 0xF0;			//设置定时器模式
	TL0 = 0x18;				//设置定时初始值
	TH0 = 0xFC;				//设置定时初始值
	TF0 = 0;				//清除TF0标志
	TR0 = 1;				//定时器0开始计时
	ET0 = 1;				//使能定时器0中断
	EA = 1;
}


void sys_init()
{
	P0=0xff;
	InitHC138(4);
	P0=0x00;
	InitHC138(5);
}

void LED(unsigned char addr,enable)
{
	static unsigned char temp=0x00,temp_old=0xff;
	if(enable)
		temp|=0x01<<addr;
	else 
		temp&=~(0x01<<addr);
	if(temp!=temp_old)
	{
		P0=~temp;
		InitHC138(4);
		temp_old=temp;
	}
}

void Key_Loop()
{
	Key_Val=ScanKey();
	Key_Down=Key_Val&(Key_Old^Key_Val);
	Key_Up=~Key_Val&(Key_Old^Key_Val);
	Key_Old=Key_Val;
	if(Key_Down==4)
	{
		show_mode++;
		if(show_mode>=3)show_mode=0;
	}
	if(show_mode==1) // 参数界面
	{
		if(Key_Down==5)
		{
			shift_mode=~shift_mode;
		}
		if(shift_mode==0)
		{
			if(Key_Down==9)
			{
				static unsigned char i=1;
				i++;
				if(i>=5)i=0;
				lim_up=upBuf[i];
			}
			if(Key_Down==8)
			{
				static unsigned char j=1;
				j++;
				if(j>=5)j=0;
				lim_down=downBuf[j];
			}
		}
		else if(shift_mode==1)
		{
			if(Key_Down==9)
			{
				flag_v=1;
			}
			if(Key_Down==8)
			{
				flag_v=0;
			}
		}
	}
		if(show_mode==2) // 记录界面
	{
		if(Key_Down==5)
		{
			c_alarm=0;
		}
	}
}

void d_show()
{
	Nixie_SetBuf(1,10);
	Nixie_SetBuf(2,19);
	Nixie_SetBuf(3,19);
	Nixie_SetBuf(4,19);
	Nixie_SetBuf(5,19);

	if(distance>99)
	{
		Nixie_SetBuf(6,distance/100);
		Nixie_SetBuf(7,(distance/10)%10);
		Nixie_SetBuf(8,distance%10);
	}
	else
	{
		Nixie_SetBuf(6,19);
		Nixie_SetBuf(7,(distance/10)%10);
		Nixie_SetBuf(8,distance%10);
	}
	
}

void set_show()
{
	Nixie_SetBuf(1,22);
	if(shift_mode==0)
	{
		Nixie_SetBuf(2,1);
	}
	else 
		Nixie_SetBuf(2,2);
	
	Nixie_SetBuf(3,19);
	Nixie_SetBuf(4,lim_down/10);
	Nixie_SetBuf(5,0);
	Nixie_SetBuf(6,20);
	Nixie_SetBuf(7,lim_up/10);
	Nixie_SetBuf(8,0);
}

void rec_show()
{
	Nixie_SetBuf(1,14);
	Nixie_SetBuf(2,19);
	Nixie_SetBuf(3,19);
	Nixie_SetBuf(4,19);
	Nixie_SetBuf(5,19);
	Nixie_SetBuf(6,19);
	Nixie_SetBuf(7,19);
	if(c_alarm>=0&&c_alarm<=9)
		Nixie_SetBuf(8,c_alarm);
	else
		Nixie_SetBuf(8,20);
}

void dac_set()
{
	
	if(shift_mode==1)
	{
		if(flag_v)
		{
			if(v>=0&&v<1)
			{
				lim_up=upBuf[0];
			}
			else if(v>=1&&v<2)
			{
				lim_up=upBuf[1];
			}
			else if(v>=2&&v<3)
				lim_up=upBuf[2];
			else if(v>=3&&v<4)
				lim_up=upBuf[3];
			else if(v>=4&&v<=5)
				lim_up=upBuf[4];
		}
		else 
			if(v>=0&&v<1)
			{
				lim_down=downBuf[0];
			}
			else if(v>=1&&v<2)
			{
				lim_down=downBuf[1];
			}
			else if(v>=2&&v<3)
				lim_down=downBuf[2];
			else if(v>=3&&v<4)
				lim_down=downBuf[3];
			else if(v>=4&&v<=5)
				lim_down=downBuf[4];
	}
}

void alarm()
{
	if(distance>lim_up || distance<lim_down)
	{
		flag_a=1;
	}
	else
		flag_a=0;
	if(flag_a!=flag_old)
	{
		if(flag_a==1)
			c_alarm++;
		flag_old=flag_a;
	}
}

void led_show()
{
	if(show_mode==0)
		{
			LED(0,1);
			LED(1,0);
			LED(2,0);
		}
	else if(show_mode==1)
		{
			LED(0,0);
			LED(1,1);
			LED(2,0);
		}
	else if(show_mode==2)
		{
			LED(0,0);
			LED(1,0);
			LED(2,1);
		}
	if(flag_a==0)
	{
		LED(7,1);
	}
	else
	{
		if(flag_led)
		{
			LED(7,1);
		}
		else 
			LED(7,0);
	}
		
}

void main()
{
	Timer0_Init();
	csb();
	Delay500ms();
	sys_init();
	c_alarm--; // 报警记录初始化修正
	while(1)
	{
		led_show();
		alarm();
		if(flag)
		{
			flag=0;
			distance=csb();
			v=(DA_Read(0x43)/51.0);
		}
		dac_set();
		if(show_mode==0)
		{
			d_show();
		}
		else if(show_mode==1)
		{
			set_show();
		}
		else if(show_mode==2)
		{
			rec_show();
		}
//		Nixie_SetBuf(1,(unsigned char)v%10);
//		Nixie_SetBuf(2,(unsigned char)(v*10)%10);
//		Nixie_SetBuf(3,(unsigned int)(v*100)%10);
	}
}
void Timer0_Isr(void) interrupt 1
{
	static unsigned char count0,count1,count2,count3;
	count0++;
	count1++;
	count2++;
	count3++;
	if(count0>=2)
	{
		count0=0;
		Nixie_Loop();
	}
	if(count1>=10)
	{
		count1=0;
		Key_Loop();
	}
	if(count2>=200)
	{
		count2=0;
		flag=1;
	}
	if(count3>=100)
	{
		count3=0;
		flag_led=~flag_led;
	}
}