#include <STC15F2K60S2.H>
#include <74hc138.H>
#include <Nixie.H>
#include <Key.H>
#include <DS1302.H>
#include <iic.H>
#include <stdio.H>

static unsigned char Key_Val, Key_Old, Key_Down, Key_Up;
static unsigned char shift_mode=0;
static unsigned int dat;
static unsigned char temp2, temp3,low,high;
static unsigned char num[4]={19,19,19,19}, flag_in=0;

static unsigned char t_old[3]={0x00,0x00,0x00},t[2]={0x00,0x00},Rct[3]={0x23,0x09,0x59};

void Delay5ms(void)	//@12.000MHz
{
	unsigned char data i, j;

	i = 59;
	j = 90;
	do
	{
		while (--j);
	} while (--i);
}


void Timer0_Init(void)		//1毫秒@12.000MHz
{
	AUXR &= 0x7F;			//定时器时钟12T模式
	TMOD &= 0xF0;			//设置定时器模式
	TL0 = 0x18;				//设置定时初始值
	TH0 = 0xFC;				//设置定时初始值
	TF0 = 0;				//清除TF0标志
	TR0 = 1;				//定时器0开始计时
	ET0 = 1;				//使能定时器0中断
	EA = 1;
}

void sys_init()
{
	P0=0xff;
	InitHC138(4);
	P0=0x00;
	InitHC138(5);
}

void LED(unsigned char addr, enable)
{
	static unsigned char temp=0x00,temp_old=0xff;
	if(enable)
		temp|=(0x01<<addr);
	else
		temp&=~(0x01<<addr);
	if(temp != temp_old)
	{
		P0 = ~temp;
		InitHC138(4);
		temp_old = temp;
	}
}

void input()
{
	if(shift_mode==1)
	{
		if(flag_in==1)
		{
			temp2=EEPROM_Read(2);
			Delay5ms();
			temp3=EEPROM_Read(3);
			Delay5ms();
			Read_Rct(t_old);
		}
//		if(flag_in==2)
//		{
//			
//		}
		if(flag_in==4)
		{
			t[0]=t_old[0];
			t[1]=t_old[1];
			dat= num[3]*1000+num[2]*100+num[1]*10+num[0];
			high= (dat>>8) & 0xFF;
			low= dat & 0xFF;
			EEPROM_Write(2,high);
			Delay5ms();
			if((temp2<=high)&&(temp3<low))
			{
				LED(3,1);
			}
			else 
				LED(3,0);
			EEPROM_Write(3,low);
			Delay5ms();
			EEPROM_Write(0,(t[0] >> 4) * 10 + (t[0] & 0x0F));
			Delay5ms();
			EEPROM_Write(1,(t[1] >> 4) * 10 + (t[1] & 0x0F));
			Delay5ms();
		}
	}
	
}

void Key_Loop()
{
	Key_Val=ScanKey();
	Key_Down=Key_Val&(Key_Old^Key_Val);
	Key_Up=~Key_Val&(Key_Old^Key_Val);
	Key_Old=Key_Val;
	if(Key_Down==4)
	{
		shift_mode++;
		if(shift_mode>=3)
			shift_mode=0;
		if(shift_mode==1)
		{
			flag_in=0;
			num[0] = 19; num[1] = 19;num[2] = 19;num[3] = 19; // 赋相同的值
		}
	}
	if(shift_mode==1)
	{
		if(Key_Down==5)
		{
			flag_in=0;
			num[0] = 19; num[1] = 19;num[2] = 19;num[3] = 19; // 赋相同的值
		}
		if(Key_Down==6||Key_Down==10||Key_Down==14||Key_Down==18||Key_Down==9||Key_Down==13||Key_Down==17||Key_Down==8||Key_Down==12||Key_Down==16)
		{
			flag_in++;
		}
		if(Key_Down==6)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=0;
			}
		}
		else if(Key_Down==10)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=1;
			}
		}
		if(Key_Down==14)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=2;
			}
		}
		if(Key_Down==18)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=3;
			}
		}
		if(Key_Down==9)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=4;
			}
		}
		if(Key_Down==13)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=5;
			}
		}
		if(Key_Down==17)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=6;
			}
		}
		if(Key_Down==8)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=7;
			}
		}
		if(Key_Down==12)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=8;
			}
		}
		if(Key_Down==16)
		{
			if(flag_in<=4)
			{
				num[3]=num[2];
				num[2]=num[1];
				num[1]=num[0];
				num[0]=9;
			}
		}
	}
}

void show_LED()
{
	if(shift_mode==0)
	{
		LED(0,1);LED(2,0);
	}
	else if(shift_mode==1)
	{
		LED(0,0);LED(1,1);
	}
	else if(shift_mode==2)
	{
		LED(2,1);LED(1,0);
	}
}

	
void time_show()
{
	Read_Rct(Rct);
	Nixie_SetBuf(1,Rct[0]/16);
	Nixie_SetBuf(2,Rct[0]%16);
	Nixie_SetBuf(3,20);
	Nixie_SetBuf(4,Rct[1]/16);
	Nixie_SetBuf(5,Rct[1]%16);
	Nixie_SetBuf(6,20);
	Nixie_SetBuf(7,Rct[2]/16);
	Nixie_SetBuf(8,Rct[2]%16);
}

void input_show()
{
	Nixie_SetBuf(1,12);
	Nixie_SetBuf(2,19);
	Nixie_SetBuf(3,19);
	Nixie_SetBuf(4,19);
	Nixie_SetBuf(5,num[3]);
	Nixie_SetBuf(6,num[2]);
	Nixie_SetBuf(7,num[1]);
	Nixie_SetBuf(8,num[0]);
}

void r_show()
{
	Nixie_SetBuf(1,14);
	Nixie_SetBuf(2,19);
	Nixie_SetBuf(3,19);
	Nixie_SetBuf(4,t[0]/16);
	Nixie_SetBuf(5,t[0]%16);
	Nixie_SetBuf(6,20);
	Nixie_SetBuf(7,t[1]/16);
	Nixie_SetBuf(8,t[1]%16);
}

void main()
{
	Timer0_Init();
	sys_init();
	Set_Rct(Rct);
	
	while(1)
	{
		input();
		show_LED();
		if(shift_mode==0)
		{
			time_show();
		}
		else if(shift_mode==1)
		{
			input_show();
		}
		else if(shift_mode==2)
		{
			r_show();
		}
		
	}
}
void Timer0_Isr(void) interrupt 1
{
	static unsigned char count0, count1;
	count0++;
	count1++;
	if(count0>=2)
	{
		count0=0;
		Nixie_Loop();
	}
	if(count1>=10)
	{
		count1=0;
		Key_Loop();
	}
	
}


