#include <STC15F2K60S2.H>
#include <74hc138.H>
#include <Nixie.H>
#include <uart.H>

static unsigned char Rec[10]={0,0,0,0,0,0,0,0,0,0};
static unsigned char rec_dex;

void Timer0_Init(void)		//1毫秒@12.000MHz
{
	AUXR &= 0x7F;			//定时器时钟12T模式
	TMOD &= 0xF0;			//设置定时器模式
	TL0 = 0x18;				//设置定时初始值
	TH0 = 0xFC;				//设置定时初始值
	TF0 = 0;				//清除TF0标志
	TR0 = 1;				//定时器0开始计时
	ET0 = 1;				//使能定时器0中断
	EA=1;
}


void LED(unsigned char addr,enable)
{
	static unsigned char temp=0x00,temp_old=0xff;
	if(enable)
		temp|=0x01<<addr;
	else
		temp&=~(0x01<<addr);
	if(temp!=temp_old)
	{
		P0=~temp;
		InitHC138(4);
		temp_old=temp;
	}
}

void Uart_Loop()
{
	if(rec_dex>0)
	{
		if(rec_dex==1)
		{
			if(Rec[0]=='A')
			{
				Nixie_SetBuf(8,10);
				LED(0,1);
			}
			else if(Rec[0]=='S')
			{
				Nixie_SetBuf(8,5);
				LED(2,1);
			}
			else 
				Nixie_SetBuf(8,14);
		}
		else
			Nixie_SetBuf(8,14);
		rec_dex=0;
	}
}

void main()
{
	Uart1_Init();
	Timer0_Init();
	P0=0xff;
	InitHC138(4);
	while(1)
	{
		Uart_Loop();
	}
}

void Timer0_Isr(void) interrupt 1
{
	static unsigned char count0,count1;
	count0++;
	count1++;
	if(count0>=2)
	{
		count0=0;
		Nixie_Loop();
	}
}

void Uart1_Isr(void) interrupt 4
{
	if (RI)				//检测串口1接收中断
	{
		Rec[rec_dex]=SBUF;
		rec_dex++;
		RI = 0;			//清除串口1接收中断请求位
	}
}