#include <STC15F2K60S2.H>
#include <74hc138.h>
#include <Key.H>
#include <Nixie.H>
#include <ds1302.h>
#include <stdio.h>

static unsigned char Rec[10]={0,0,0,0,0,0,0,0,0,0};
static unsigned char rec_dex;
static unsigned char Key_val,Key_old,Key_up,Key_down;
unsigned char h,m,s;
static unsigned int read_cnt = 0;

static unsigned char ucRct[3]={0x19,0x55,0x55};
unsigned char t[3];
static bit flag=0;
void Timer0_Init(void)		//1毫秒@12.000MHz
{
	AUXR &= 0x7F;			//定时器时钟12T模式
	TMOD &= 0xF0;			//设置定时器模式
	TL0 = 0x18;				//设置定时初始值
	TH0 = 0xFC;				//设置定时初始值
	TF0 = 0;				//清除TF0标志
	TR0 = 1;				//定时器0开始计时
	ET0 = 1;				//使能定时器0中断
}


void Key_Loop()
{
	Key_val=ScanKey();
	Key_down=Key_val&(Key_old^Key_val);
	Key_up=~Key_val&(Key_old^Key_val);
	Key_old=Key_val;
	if(Key_down==9)
	{
		flag=1;
	}
}

void main()
{
	Timer0_Init();
	Uart1_Init();
	SetRct(ucRct);
	while(1)
	{
		if(read_cnt=1)
		{
			read_cnt = 0;
			ReadRct(t);
		}
		Nixie_SetBuf(1,t[0]/16);
		Nixie_SetBuf(2,t[0]%16);
		Nixie_SetBuf(4,t[1]/16);
		Nixie_SetBuf(5,t[1]%16);
		Nixie_SetBuf(7,t[2]/16);
		Nixie_SetBuf(8,t[2]%16);
		if(flag)
		{
			flag=0;
			printf("Time:%02x:%02x:%02x",(int)t[0],(int)t[1],(int)t[2]);
//			((t[0]>>4)*10)+(t[0]&0x0f),((t[1]>>4)*10)+(t[1]&0x0f),((t[2]>>4)*10)+(t[2]&0x0f));
		}
	}
}

void Timer0_Isr(void) interrupt 1
{
	static unsigned char count0,count1;
	static unsigned int count2;
	count0++;
	count1++;
	count2++;
	if(count0>=2)
	{
		count0=0;
		Nixie_Loop();
	}
	if(count1>=10)
	{
		count1=0;
		Key_Loop();
	}
	if(count2>=500)
	{
		count2=0;
		read_cnt = 1;
	}
}

void Uart1_Isr(void) interrupt 4
{
	if (RI)				//检测串口1接收中断
	{
		Rec[rec_dex]=SBUF;
		rec_dex++;
		RI = 0;			//清除串口1接收中断请求位
	}
}

