#include <STC15F2K60S2.H>
#include <74HC138.H>
#include <Nixie.h>

unsigned char num = 99; //ʱ趨룩
unsigned char flag;     //ʱ3־λ

void Timer0_Init(void)		//1@12.000MHz
{
	AUXR &= 0x7F;			//ʱʱ12Tģʽ
	TMOD &= 0xF0;			//öʱģʽ
	TL0 = 0x18;				//öʱʼֵ
	TH0 = 0xFC;				//öʱʼֵ
	TF0 = 0;				//TF0־
	TR0 = 1;				//ʱ0ʼʱ
	ET0 = 1;				//ʹܶʱ0ж
	EA = 1;
}

void sys_init()		// ϵͳʼ رLED̵ͷ
{
	P0 = 0xff;
	InitHC138(4);
	P0 = 0x00;
	InitHC138(5);
}

void LED(unsigned char addr,enable)
{
	static unsigned char temp = 0x00;
	static unsigned char temp_old = 0xff;
	if(enable)
		temp |= 0x01<<addr;
	else
		temp &= ~(0x01<<addr);
	if(temp != temp_old)
	{
		P0 = ~temp;
		InitHC138(4);
		// P2 = P2 & 0x1f | 0x80;
		// P2 &= 0x1f;
		temp_old = temp;
	}
}

void Relay(unsigned char flag)
{
	static unsigned char temp = 0x00;
	static unsigned char temp_old = 0xff;
	if(flag)
		temp |= 0x01<<4;
	else
		temp &= ~(0x01<<4);
	if(temp != temp_old)
	{
		P0 = temp;
		InitHC138(5);
		// P2 = P2 & 0x1f | 0x80;
		// P2 &= 0x1f;
		temp_old = temp;
	}
}

void main()
{
	Timer0_Init();
	sys_init();
	while(1)
	{
		Nixie_SetBuf(1,num/10);
		Nixie_SetBuf(2,num%10);
		if(num>0&&num<=3)
		{
			flag=1;
			Relay(1);
		}
		else
		{
			flag=0;
			Relay(0);
		}
		if(num<=0)
			num = 20;
	}
}

void Timer0_Isr(void) interrupt 1
{
	static unsigned char count1=0;
	static unsigned int count2;
	static unsigned int count3;
	count1++;
	count2++;
	if(count1>=2)
	{
		Nixie_Loop();
		count1=0;
	}
	if(count2>=1000)
	{
		num--;
		count2=0;
	}
	if(flag==1)
	{
		count3++;
		if(count3>=0&&count3<=500)
		{
			//LED(1,1);
			P0 = 0x00;
			InitHC138(4);
		}
		if(count3>500&&count3<=1000)
		{
			P0 = 0xff;
			InitHC138(4);
		}
		if(count3>=1001)
			count3 = 0;	
	}
}