#include <STC15F2K60S2.H>
#include <74hc138.h>
#include <Key.H>
#include <Nixie.H>

unsigned char Key_Val,Key_Old,Key_Up,Key_Down;
unsigned char flag = 0;
unsigned char num = 19;
void Timer0_Init(void)		//1ms@12.000MHz
{
	AUXR &= 0x7F;			//Timer clock is 12T mode
	TMOD &= 0xF0;			//Set timer work mode
	TL0 = 0x18;				//Initial timer value
	TH0 = 0xFC;				//Initial timer value
	TF0 = 0;				//Clear TF0 flag
	TR0 = 1;				//Timer0 start run
	ET0 = 1;				//Enable timer0 interrupt
	EA = 1;
}


void sys_init()
{
	P0 = 0xff;
	InitHC138(4);
	P0 = 0x00;
	InitHC138(5);
}

void Key_Loop()
{
	Key_Val=ScanKey();
	Key_Down=Key_Val&(Key_Old^Key_Val);
	Key_Up=~Key_Val&(Key_Old^Key_Val);
	Key_Old=Key_Val;
	if(Key_Down!=0)
	{
		num=Key_Down;
		flag=1;
		P0 = 0xff;
	}
	if(Key_Up==num&&flag==2)
	{
		P0 = ~P0;
		InitHC138(4);
		flag=0;
	}
	
}

void main()
{
	sys_init();
	Timer0_Init();
	while(1)
	{
			Nixie_SetBuf(1,num/10);
			Nixie_SetBuf(2,num%10);
			Nixie_SetBuf(5,num);
	}
}

void Timer0_Isr(void) interrupt 1
{
	static unsigned char count1,count2;
	static int count3;
	count1++;
	count2++;
	if(flag==1)
		count3++;
	if(count1>=2)
	{
		Nixie_Loop();
		count1=0;
	}
	if(count2>=10)
	{
		Key_Loop();
		count2=0;
	}
	if(count3>=500)
	{
		flag=2;
		count3=0;
	}
}
