#include <STC15F2K60S2.H>
#include <74hc138.H>
#include <Nixie.H>
#include <Key.H>
#include <onewire.H>

bit flag=1,flag_t;
unsigned char Key_Val, Key_Old, Key_Up, Key_Down;
float t;

void Delay(unsigned int xms)	//@12.000MHz
{
	while(xms--)
	{
			unsigned char data i, j;

		i = 12;
		j = 169;
		do
		{
			while (--j);
		} while (--i);
	}

}

void sys_init()
{
	P0=0xff;
	InitHC138(4);
	P0=0x00;
	InitHC138(5);
}

void Timer0_Init(void)		//1毫秒@12.000MHz
{
	AUXR &= 0x7F;			//定时器时钟12T模式
	TMOD &= 0xF0;			//设置定时器模式
	TL0 = 0x18;				//设置定时初始值
	TH0 = 0xFC;				//设置定时初始值
	TF0 = 0;				//清除TF0标志
	TR0 = 1;				//定时器0开始计时
	ET0 = 1;				//使能定时器0中断
	EA = 1;
}

void Key_Loop()
{
	Key_Val=ScanKey();
	Key_Up=~Key_Val&(Key_Old^Key_Val);
	Key_Down=Key_Val&(Key_Old^Key_Val);
	Key_Old=Key_Val;
	if(Key_Down==9&&flag==1)
	{
		flag=0;
	}
	else if(Key_Down==9&&flag==0)
		flag=1;
}


void main()
{
	Timer0_Init();
	sys_init();
	read_t();
	Delay(750);
	while(1)
	{
		if(flag==1)
		{
			Nixie_SetBuf(4,19);
			Nixie_SetBuf(5,(unsigned char)t/10);
			Nixie_SetBuf(6,(unsigned char)t%10);
			Nixie_SetBuf(7,(unsigned int)(t*10)%10);
			Nixie_SetBuf(8,12);
			point[6]=1;
			point[5]=0;
		}
		else if(flag==0)
		{
			Nixie_SetBuf(4,(unsigned char)t/10);
			Nixie_SetBuf(5,(unsigned char)t%10);
			Nixie_SetBuf(6,(unsigned int)(t*10)%10);
			Nixie_SetBuf(7,(unsigned int)(t*100)%10);
			Nixie_SetBuf(8,12);
			point[6]=0;
			point[5]=1;
		}
		if(flag_t==1)
		{
			flag_t=0;
			t=read_t();
		}
	}
}
void Timer0_Isr(void) interrupt 1
{
	static unsigned char count0, count1;
	static unsigned int count2;
	count0++;
	count1++;
	count2++;
	if(count0>=2)
	{
		count0=0;
		Nixie_Loop();
	}
	if(count1>=10)
	{
		count1=0;
		Key_Loop();
	}
		if(count2>=200)
	{
		count2=0;
		flag_t=1;
	}
}
