#include <STC15F2K60S2.H>
#include <74HC138.H>
#include <Nixie.h>
#include <onewire.h>
#include <ds1302.h>

float temper;
bit flag_t=0;
unsigned char ucRtc[3]={0x19,0x55,0x55};
void Delay(unsigned int x)		//@12.000MHz
{
	unsigned char data i, j;
	while(x--)
	{
		i = 12;
		j = 169;
		do
		{
			while (--j);
		} while (--i);
	}
}


void Timer0_Init(void)		//1ms@12.000MHz
{
	AUXR &= 0x7F;			//Timer clock is 12T mode
	TMOD &= 0xF0;			//Set timer work mode
	TL0 = 0x18;				//Initial timer value
	TH0 = 0xFC;				//Initial timer value
	TF0 = 0;				//Clear TF0 flag
	TR0 = 1;				//Timer0 start run
	ET0 = 1;				//Enable timer0 interrupt
	EA = 1;
}

void sys_init(void)
{
	P0=0xff;
	InitHC138(4);
	P0=0x00;
	InitHC138(5);
}

void LED(unsigned char addr,enable)
{
	static unsigned char temp = 0x00;
	static unsigned char temp_old = 0xff;
	if(enable)
		temp |= 0x01<<addr;
	else
		temp &= ~(0x01<<addr);
	if(temp != temp_old)
	{
		P0 = ~temp;
		InitHC138(4);
		// P2 = P2 & 0x1f | 0x80;
		// P2 &= 0x1f;
		temp_old = temp;
	}
}

void main()
{
	sys_init();
	Timer0_Init();
	read_t();
	Delay(1000);
	Set_Rtc(ucRtc);
	while(1)
	{
//		if(flag_t==1)
//		{
//			temper=read_t();
//			flag_t=0;
//		}
//		Nixie_SetBuf(1,(unsigned char)temper/10);
//		Nixie_SetBuf(2,(unsigned char)temper%10);
//		Nixie_SetBuf(3,(unsigned int)(temper*10)%10);
//		Nixie_SetBuf(4,(unsigned int)(temper*100)%10);
//		Nixie_SetBuf(8,18);
//		point[2]=1;
		// clock display
		Read_Rtc(ucRtc);
		Nixie_SetBuf(1,ucRtc[0]/16);
		Nixie_SetBuf(2,ucRtc[0]%16);
		Nixie_SetBuf(3,20);
		Nixie_SetBuf(4,ucRtc[1]/16);
		Nixie_SetBuf(5,ucRtc[1]%16);
		Nixie_SetBuf(6,20);
		Nixie_SetBuf(7,ucRtc[2]/16);
		Nixie_SetBuf(8,ucRtc[2]%16);
	}
}

void Timer0_Isr(void) interrupt 1
{
	static unsigned char count1,count2;
	static unsigned int count3;
	count1++;
	count3++;
	if(count1>=2)
	{
		count1=0;
		Nixie_Loop();
	}
	if(count3>=500)
	{
		count3=0;
		flag_t=1;
	}
	
}