#include "ds1302.h"
/********************************************************************/ 
/*ֽдһֽ*/
void Write_Ds1302_Byte(unsigned char dat) 
{
	unsigned char i;
	SCK = 0;
	for (i=0;i<8;i++) 
	{ 
		if (dat & 0x01) 	// ȼif((addr & 0x01) ==1) 
		{
			SDA_SET;		//#define SDA_SET SDA=1 /*ƽø*/
		}
		else 
		{
			SDA_CLR;		//#define SDA_CLR SDA=0 /*ƽõ*/
		}		 
		SCK_SET;
		SCK_CLR;		
		dat = dat >> 1; 
	} 
}
/********************************************************************/ 
/*ֽڶһֽ*/
unsigned char Read_Ds1302_Byte(void) 
{
	unsigned char i, dat=0;	
	for (i=0;i<8;i++)
	{	
		dat = dat >> 1;
		if (SDA_R) 	  //ȼif(SDA_R==1)    #define SDA_R SDA /*ƽȡ*/	
		{
			dat |= 0x80;
		}
		else 
		{
			dat &= 0x7F;
		}
		SCK_SET;
		SCK_CLR;
	}
	return dat;
}

/********************************************************************/ 
/*DS1302 ֽдһֽ*/
void Ds1302_Single_Byte_Write(unsigned char addr, unsigned char dat)
{ 

	RST_CLR;			/*RSTõͣʵDS1302ĳʼ*/
	SCK_CLR;			/*SCKõͣʵDS1302ĳʼ*/

	RST_SET;			/*DS1302,RST=1ƽø */
	addr = addr & 0xFE;	 
	Write_Ds1302_Byte(addr); /*дĿַaddr,֤д,д֮ǰλ*/	
	Write_Ds1302_Byte(dat);	 /*дݣdat*/
	RST_CLR;				 /*ֹͣDS1302*/
}

/********************************************************************/ 
/*DS1302ֽڶһֽ*/
unsigned char Ds1302_Single_Byte_Read(unsigned char addr) 
{ 
	unsigned char temp;
	RST_CLR;			/*RSTõͣʵDS1302ĳʼ*/
	SCK_CLR;			/*SCKõͣʵDS1302ĳʼ*/

	RST_SET;	/*DS1302,RST=1ƽø */	
	addr = addr | 0x01;	 
	Write_Ds1302_Byte(addr); /*дĿַaddr,֤Ƕ,д֮ǰλø*/
	temp=Read_Ds1302_Byte(); /*DS1302жһֽڵ*/		
	RST_CLR;	/*ֹͣDS1302*/
	return temp;
}

void Set_Rtc(unsigned char *ucRtc)
{
    Write_Ds1302_Byte(0x8e);  // ??
    Write_Ds1302_Byte(0x00);  // ??
    Write_Ds1302_Byte(0x84);  // ??
    Write_Ds1302_Byte(ucRtc[0]);  // ??
    Write_Ds1302_Byte(0x82);  // ??
    Write_Ds1302_Byte(ucRtc[1]);  // ??
    Write_Ds1302_Byte(0x80);  // ??
    Write_Ds1302_Byte(ucRtc[2]);  // ??
    Write_Ds1302_Byte(0x8e);  // ??
    Write_Ds1302_Byte(0x80);  // ??
}


void Read_Rtc(unsigned char *ucRtc)
{
	ucRtc[0]=Read_Ds1302_Byte(0x85);
	ucRtc[1]=Read_Ds1302_Byte(0x83);
	ucRtc[2]=Read_Ds1302_Byte(0x81);
}