#include <STC15F2K60S2.H>
#include <Nixie.h>
#include <iic.h>
#include <74hc138.h>
#include <Key.h>

unsigned char Key_Val,Key_Old,Key_Up,Key_Down;
unsigned char light, num;
unsigned char u;
bit flag_light;

void Delay(unsigned int xms)	//@12.000MHz
{
	unsigned char data i, j;
while(xms--)
	{
		i = 12;
			j = 169;
			do
			{
				while (--j);
			} while (--i);
}
}


void Key_Loop()
{
	Key_Val=ScanKey();
	Key_Down=Key_Val&(Key_Old^Key_Val);
	Key_Up=~Key_Val&(Key_Old^Key_Val);
	Key_Old=Key_Val;
	if(Key_Down==4)num++;
}

void sys_init()
{
	P0 = 0xff;
	InitHC138(4);
	P0 = 0x00;
	InitHC138(5);
}

void Timer0_Init(void)		//1ms@12.000MHz
{
	AUXR &= 0x7F;			//Timer clock is 12T mode
	TMOD &= 0xF0;			//Set timer work mode
	TL0 = 0x18;				//Initial timer value
	TH0 = 0xFC;				//Initial timer value
	TF0 = 0;				//Clear TF0 flag
	TR0 = 1;				//Timer0 start run
	ET0 = 1;				//Enable timer0interrupt
	EA = 1;
}


void main()
{
	Timer0_Init();
	sys_init();
//	EEPROM_Write(0,0); // EEPROM写入
//	Delay(2);
	num=EEPROM_Read(0);
	while(1)
	{
		EEPROM_Write(0,num);Delay(5);
		Nixie_SetBuf(1,num);
//		u=AD_Read(0x43); // 电压
//		Nixie_SetBuf(1,u/100);
//		Nixie_SetBuf(2,u/10%10);
//		Nixie_SetBuf(3,u%10);
//		light = AD_Read(0x41); // 光敏
//		Nixie_SetBuf(1,light/100);
//		Nixie_SetBuf(2,light/10%10);
//		Nixie_SetBuf(3,light%10);
//		if (flag_light==1)
//		{
//			flag_light=0;
//			light=AD_Read(0x41);
//		}
//		DA_Write(1.92*51.0); // 模拟量电压输出
	}
}

void Timer0_Isr(void) interrupt 1
{
	static unsigned char count0,count1;
	static unsigned int count2;
	count0++;
	count1++;
	count2++;
	if(count0>=2)
	{
		count0=0;
		Nixie_Loop();
	}
	if(count1>=10)
	{
		count1=0;
		Key_Loop();
	}
	if(count2>=500)
	{
		count2=0;
		flag_light=1;
	}
}
