#include <STC15F2K60S2.H>
#include <74hc138.H>
#include <Nixie.h>
#include <Key.h>
#include <onewire.h>
#include <iic.h>

float t,u,light,da;
bit flag_t;
unsigned char key_val, key_old, key_up, key_down;
static unsigned char shift=0;
bit mode;

void Delay(unsigned int xms)	//@12.000MHz
{
	unsigned char data i, j;
	while(xms--)
	{
		i = 12;
		j = 169;
		do
		{
			while (--j);
		} while (--i);
	}
}

void Timer0_Init(void)		//1毫秒@12.000MHz
{
	AUXR &= 0x7F;			//定时器时钟12T模式
	TMOD &= 0xF0;			//设置定时器模式
	TL0 = 0x18;				//设置定时初始值
	TH0 = 0xFC;				//设置定时初始值
	TF0 = 0;				//清除TF0标志
	TR0 = 1;				//定时器0开始计时
	ET0 = 1;				//使能定时器0中断
	EA = 1;
}

void Key_Loop()
{
	key_val=ScanKey();
	key_up=~key_val&(key_old^key_val);
	key_down=key_val&(key_old^key_val);
	key_old=key_val;
	if(key_down==4)
	{
		shift++;
		if(shift>=3)shift=0;
		if(shift==2&&mode==1)mode=0;
	}
	if(key_down==5)
	{
		mode=~mode;
	}
}

void LED(unsigned char addr, enble)
{
	static unsigned char temp = 0x00, temp_old = 0xff;
	if(enble)
	{
		temp |= (0x01<<addr);
	}
	else temp &= ~(0x01<<addr);
	if(temp!=temp_old)
	{
		P0 = ~temp;
		InitHC138(4);
		temp_old=temp;
	}
}

void temp_show()
{
		Nixie_SetBuf(1,12);
		Nixie_SetBuf(2,19);
		Nixie_SetBuf(3,19);
		Nixie_SetBuf(4,19);
		Nixie_SetBuf(5,19);
		Nixie_SetBuf(6,(unsigned char)t/10);
		Nixie_SetBuf(7,(unsigned char)t%10);
		Nixie_SetBuf(8,(unsigned int)(t*10)%10);
		point[7]=1;
		point[6]=0;
}

void u_show()
{
		Nixie_SetBuf(1,21);
		Nixie_SetBuf(2,22);
		Nixie_SetBuf(4,19);
		Nixie_SetBuf(5,19);
		point[7]=0;
		point[6]=1;
		if(mode==0)
		{
			Nixie_SetBuf(3,1);
			Nixie_SetBuf(6,(unsigned int)light%10);
			Nixie_SetBuf(7,(unsigned int)(light*10)%10);
			Nixie_SetBuf(8,(unsigned int)(light*100)%10);
		}
		if(mode==1)
		{
			Nixie_SetBuf(3,3);
			Nixie_SetBuf(6,(unsigned int)u%10);
			Nixie_SetBuf(7,(unsigned int)(u*10)%10);
			Nixie_SetBuf(8,(unsigned int)(u*100)%10);
		}
}

void dac_show()
{
		Nixie_SetBuf(1,10);
		Nixie_SetBuf(2,19);
		Nixie_SetBuf(3,19);
		Nixie_SetBuf(4,19);
		Nixie_SetBuf(5,19);
		Nixie_SetBuf(6,(unsigned char)da%10);
		Nixie_SetBuf(7,(unsigned char)(da*10)%10);
		Nixie_SetBuf(8,(unsigned int)(da*100)%10);
	  da=0.1*t-0.5;
		point[7]=0;
		point[6]=1;
}

void led_show()
{
	if(shift==0)
	{
		LED(0,1);
		LED(1,0);
		LED(2,0);
		LED(3,0);
		LED(4,0);
	}
	else if(shift==1)
	{
		LED(0,0);
		LED(1,1);
		LED(2,0);
		if(mode==0)
		{
			LED(3,1);
			LED(4,0);
		}
		else
		{
			LED(3,0);
			LED(4,1);
		}
	}
	else if(shift==2)
	{
		LED(0,0);
		LED(1,0);
		LED(2,1);
		LED(3,0);
		LED(4,0);
	}
}

void da_out()
{
		if(t>=15&&t<=45)
		{
			DA_Write((0.1*t-0.5)*51.0);
		}
		else if(t<15)DA_Write(1.0*51.0);
		else if(t>45)DA_Write(4.0*51.0);
}
	

void main()
{
	Timer0_Init();
	read_t();
	Delay(1000);
	while(1)
	{
		led_show();
		da_out();
		if(flag_t)
		{
			flag_t=0;
			t=read_t();
			light=AD_Read(0x43)/51.0;
			u=AD_Read(0x41)/51.0;
		}
		if(shift==0)temp_show();
		else if(shift==1)u_show();
		else if(shift==2)dac_show();
	}
}

void Timer0_Isr(void) interrupt 1
{
	static unsigned char count0, count1;
	static unsigned int count2, count3, count4;
	count0++;
	count1++;
	count2++;
	count3++;
	count4++;
	if(count0>=10)
	{
		count0=0;
		Key_Loop();
	}
	if(count1>=2)
	{
		count1=0;
		Nixie_Loop();
	}
	if(count2>=500)
	{
		count2=0;
		flag_t=1;
	}
}
