#include <STC15F2K60S2.h>
#include "DS.h"
#include "DS18B20.h"

#define Y5 0xA0
#define Y4 0x80

bit S7_Flag = 0;
bit S6_Flag = 0;
bit S5_Flag = 0;
bit S4_Flag = 0;
bit S11_Flag = 0;
bit S10_Flag = 0;
bit S9_Flag = 0;
bit S8_Flag = 0;
bit S15_Flag = 0;
bit S14_Flag = 0;
bit S13_Flag = 0;
bit S12_Flag = 0;

unsigned int Tmperature,temperature;
 
void InitBan();
void KeyPress();
void Delay5ms();	

void main()
{
	unsigned char yi,er,san;
	InitBan();
	while(1)
	{
		KeyPress();
		write_DS18B20(0x44);
		temperature = Read_DS18B20();
		yi = temperature/100;
		er = temperature%100/10;
		san = temperature%10;
		DS3(yi,er,san);
	}
}

void InitBan()
{
	P2 = Y5;
	P0 = 0x00;
	P2 = 0x00;
	
	P2 = Y4;
	P0 = 0xFF;
	P2 = 0x00;
}

void Delay5ms()		//@11.0592MHz
{
	unsigned char i, j;

	i = 54;
	j = 199;
	do
	{
		while (--j);
	} while (--i);
}

void KeyPress()
{
	unsigned val;
	
	P3 = 0x0F; P42 = 0; P44 = 0; //
	if (P3 != 0x0F)
	{
		Delay5ms();
		if (P3 != 0x0F)
		{
			switch (P3)
			{
				case 0x0E: val = 1; break;
				case 0x0D: val = 2; break;
				case 0x0B: val = 3; break;
				case 0x07: val = 4; break;
			}
		}
	}
	
	P3 = 0xF0; P42 = 1; P44 = 1; //
	if (P44 == 0)
	{
		Delay5ms();
		if (P44 == 0) val = val + 0;
	}
		
	if (P42 == 0) 
	{
		Delay5ms();
		if (P42 == 0) val = val + 4;
	}
	if (P35 == 0) 
	{
		Delay5ms();
		if (P35 == 0)  val = val + 8;
	}
	if (P34 == 0)
	{
		Delay5ms();
		if (P34 == 0) val = val + 12;
	}
	
	switch (val)
	{
		case 1: S7_Flag = 1; break;
		case 2: S6_Flag = 1; break;
		case 3: S5_Flag = 1; break;
		case 4: S4_Flag = 1; break;
		case 5: S11_Flag = 1; break;
		case 6: S10_Flag = 1; break;
		case 7: S9_Flag = 1; break;
		case 8: S8_Flag = 1; break;
		case 9: S15_Flag = 1; break;
		case 10: S14_Flag = 1; break;
		case 11: S13_Flag = 1; break;
		case 12: S12_Flag = 1; break;
		default: break;
	}
	
}
